/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.car.entity.car.base;

import de.maxhenkel.car.entity.car.base.EntityCarInventoryBase;
import de.maxhenkel.car.items.ItemKey;
import de.maxhenkel.car.items.ModItems;
import de.maxhenkel.car.sounds.ModSounds;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class EntityCarLockBase
extends EntityCarInventoryBase {
    private static final EntityDataAccessor<Boolean> LOCKED = SynchedEntityData.m_135353_(EntityCarInventoryBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public EntityCarLockBase(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    @Override
    public boolean canPlayerEnterCar(Player player) {
        if (this.isLocked()) {
            player.m_5661_((Component)new TranslatableComponent("message.car_locked"), true);
            return false;
        }
        return super.canPlayerEnterCar(player);
    }

    @Override
    public void destroyCar(Player player, boolean dropParts) {
        if (this.isLocked() && !player.m_20310_(2)) {
            player.m_5661_((Component)new TranslatableComponent("message.car_locked"), true);
            return;
        }
        super.destroyCar(player, dropParts);
    }

    @Override
    public boolean canPlayerAccessInventoryExternal(Player player) {
        if (this.isLocked()) {
            return false;
        }
        return super.canPlayerAccessInventoryExternal(player);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(LOCKED, (Object)Boolean.FALSE);
    }

    public void setLocked(boolean locked, boolean playsound) {
        if (locked && playsound) {
            this.playLockSound();
        } else if (!locked && playsound) {
            this.playUnLockSound();
        }
        this.f_19804_.m_135381_(LOCKED, (Object)locked);
    }

    public boolean isLocked() {
        return (Boolean)this.f_19804_.m_135370_(LOCKED);
    }

    public void playLockSound() {
        ModSounds.playSound(this.getLockSound(), this.f_19853_, this.m_142538_(), null, SoundSource.MASTER, 1.0f);
    }

    public void playUnLockSound() {
        ModSounds.playSound(this.getUnLockSound(), this.f_19853_, this.m_142538_(), null, SoundSource.MASTER, 1.0f);
    }

    public SoundEvent getLockSound() {
        return ModSounds.CAR_LOCK;
    }

    public SoundEvent getUnLockSound() {
        return ModSounds.CAR_UNLOCK;
    }

    @Override
    protected void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("locked", this.isLocked());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setLocked(compound.m_128471_("locked"), false);
    }

    @Override
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        UUID uuid;
        ItemStack stack = player.m_21120_(hand);
        if (!this.isLocked() && player.m_6144_() && player.m_150110_().f_35937_ && !stack.m_41619_() && stack.m_41720_().equals((Object)ModItems.KEY) && (uuid = ItemKey.getCar(stack)) == null) {
            ItemKey.setCar(stack, this.m_142081_());
            return InteractionResult.CONSUME;
        }
        return super.m_6096_(player, hand);
    }
}

